/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class VWRouteBubbleRenderer {
    protected static final int MARGIN_QUADRANT = 5;
    protected boolean m_bMapIsEditable = true;
    protected VWBaseStepUI m_stepUI = null;
    protected int m_nCurrentQuadrant = -1;
    protected Point m_sourcePoint = null;
    protected Point m_endPoint = null;
    protected int[] m_arrowXPts = new int[3];
    protected int[] m_arrowYPts = new int[3];

    public VWRouteBubbleRenderer(VWBaseStepUI stepUI) {
        this.m_stepUI = stepUI;
    }

    public Rectangle getBounds() {
        int nQuadrupleMargin = 20;
        Rectangle bounds = this.m_stepUI.getImageBounds();
        bounds.grow(nQuadrupleMargin, nQuadrupleMargin);
        return bounds;
    }

    public int getQuadrantFromPoint(Point point) {
        this.reset();
        int nTripleMargin = 15;
        int nQuadrupleMargin = 20;
        int nOffset = (VWBaseStepUI.s_imageDim.width + nTripleMargin) / 3;
        Rectangle testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5;
        testRect.y = this.m_stepUI.getImageY() - 5;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(-2.356194490192345, false);
            this.m_sourcePoint.x += 3;
            this.m_sourcePoint.y += 3;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x - nTripleMargin, this.m_sourcePoint.y - nTripleMargin);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 8;
            return 8;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5 + nOffset;
        testRect.y = this.m_stepUI.getImageY() - 5;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(-1.5707963267948966, false);
            this.m_sourcePoint.y += 2;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x, this.m_sourcePoint.y - nQuadrupleMargin);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 1;
            return 1;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5 + nOffset * 2;
        testRect.y = this.m_stepUI.getImageY() - 5;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(-0.7853981633974483, false);
            this.m_sourcePoint.x -= 3;
            this.m_sourcePoint.y += 3;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x + nTripleMargin, this.m_sourcePoint.y - nTripleMargin);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 2;
            return 2;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5;
        testRect.y = this.m_stepUI.getImageY() - 5 + nOffset;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(-Math.PI, false);
            this.m_sourcePoint.x += 2;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x - nQuadrupleMargin, this.m_sourcePoint.y);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 7;
            return 7;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5 + nOffset * 2;
        testRect.y = this.m_stepUI.getImageY() - 5 + nOffset;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(0.0, false);
            this.m_sourcePoint.x -= 2;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x + nQuadrupleMargin, this.m_sourcePoint.y);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 3;
            return 3;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5;
        testRect.y = this.m_stepUI.getImageY() - 5 + nOffset * 2;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(2.356194490192345, false);
            this.m_sourcePoint.x += 3;
            this.m_sourcePoint.y -= 3;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x - nTripleMargin, this.m_sourcePoint.y + nTripleMargin);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 6;
            return 6;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5 + nOffset;
        testRect.y = this.m_stepUI.getImageY() - 5 + nOffset * 2;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(1.5707963267948966, false);
            this.m_sourcePoint.y -= 2;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x, this.m_sourcePoint.y + nQuadrupleMargin);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 5;
            return 5;
        }
        testRect = new Rectangle();
        testRect.x = this.m_stepUI.getImageX() - 5 + nOffset * 2;
        testRect.y = this.m_stepUI.getImageY() - 5 + nOffset * 2;
        testRect.width = nOffset;
        testRect.height = nOffset;
        if (testRect.contains(point)) {
            this.m_sourcePoint = this.m_stepUI.getBoundaryPoint(0.7853981633974483, false);
            this.m_sourcePoint.x -= 3;
            this.m_sourcePoint.y -= 3;
            if (this.pointInsideBubble(point)) {
                this.m_endPoint = new Point(this.m_sourcePoint.x + nTripleMargin, this.m_sourcePoint.y + nTripleMargin);
                this.createArrowHead();
            }
            this.m_nCurrentQuadrant = 4;
            return 4;
        }
        if (this.m_stepUI.contains(point)) {
            this.m_nCurrentQuadrant = 0;
            return 0;
        }
        return -1;
    }

    public void paintComponent(Graphics g) {
        if (this.m_bMapIsEditable && this.m_sourcePoint != null) {
            g.fillOval(this.m_sourcePoint.x - 5, this.m_sourcePoint.y - 5, 10, 10);
            if (this.m_endPoint != null) {
                g.drawLine(this.m_sourcePoint.x, this.m_sourcePoint.y, this.m_endPoint.x, this.m_endPoint.y);
                g.fillPolygon(this.m_arrowXPts, this.m_arrowYPts, 3);
            }
        }
    }

    public boolean displayHoverIcon() {
        return this.m_nCurrentQuadrant != -1;
    }

    public void setMapIsEditable(boolean isEditable) {
        this.m_bMapIsEditable = isEditable;
    }

    public void reset() {
        this.m_nCurrentQuadrant = -1;
        this.m_sourcePoint = null;
        this.m_endPoint = null;
        this.m_arrowXPts = new int[3];
        this.m_arrowYPts = new int[3];
    }

    private boolean pointInsideBubble(Point point) {
        if (this.m_sourcePoint != null) {
            Rectangle rect = new Rectangle();
            rect.x = this.m_sourcePoint.x - 5;
            rect.y = this.m_sourcePoint.y - 5;
            rect.width = 10;
            rect.height = 10;
            return rect.contains(point);
        }
        return false;
    }

    private void createArrowHead() {
        double height = 7.0;
        double width = 6.0;
        double r = Math.sqrt(48.25);
        double theta = Math.atan2(3.5, 6.0);
        double horz = this.m_endPoint.x - this.m_sourcePoint.x;
        double vert = this.m_endPoint.y - this.m_sourcePoint.y;
        double angle = 0.0;
        if (horz != 0.0) {
            angle = Math.atan(vert / horz);
            if (horz < 0.0) {
                angle = vert > 0.0 ? Math.PI + angle : -Math.PI + angle;
            }
        } else {
            angle = vert > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        this.m_arrowXPts[0] = this.m_endPoint.x;
        this.m_arrowYPts[0] = this.m_endPoint.y;
        this.m_arrowXPts[1] = (int)Math.round((double)this.m_endPoint.x + r * Math.cos(angle + Math.PI + theta));
        this.m_arrowYPts[1] = (int)Math.round((double)this.m_endPoint.y + r * Math.sin(angle + Math.PI + theta));
        this.m_arrowXPts[2] = (int)Math.round((double)this.m_endPoint.x + r * Math.cos(angle + Math.PI - theta));
        this.m_arrowYPts[2] = (int)Math.round((double)this.m_endPoint.y + r * Math.sin(angle + Math.PI - theta));
    }
}

